<?php

/* =============================================================================================================
 * ISO 639-1 Language Codes
 * http://en.wikipedia.org/wiki/List_of_ISO_639-1_codes
 ============================================================================================================= */
$language = [
    'aa' => ['name' => 'Afar', 'flag' => 'et'],
    'ab' => ['name' => 'Abkhazian', 'flag' => 'ge'],
    'af' => ['name' => 'Afrikaans', 'flag' => 'za'],
    'am' => ['name' => 'Amharic', 'flag' => 'et'],
    'ar' => ['name' => 'Arabic', 'flag' => 'sa'],
    'as' => ['name' => 'Assamese', 'flag' => 'in'],
    'ay' => ['name' => 'Aymara', 'flag' => 'bo'],
    'az' => ['name' => 'Azerbaijani', 'flag' => 'az'],
    'ba' => ['name' => 'Bashkir', 'flag' => 'ru'],
    'be' => ['name' => 'Byelorussian', 'flag' => 'by'],
    'bg' => ['name' => 'Bulgarian', 'flag' => 'bg'],
    'bh' => ['name' => 'Bihari', 'flag' => 'in'],
    'bi' => ['name' => 'Bislama', 'flag' => 'vu'],
    'bn' => ['name' => 'Bengali/Bangla', 'flag' => 'bd'],
    'bo' => ['name' => 'Tibetan', 'flag' => 'cn'],
    'br' => ['name' => 'Breton', 'flag' => 'fr'],
    'ca' => ['name' => 'Catalan', 'flag' => 'es'],
    'co' => ['name' => 'Corsican', 'flag' => 'fr'],
    'cs' => ['name' => 'Czech', 'flag' => 'cz'],
    'cy' => ['name' => 'Welsh', 'flag' => 'gb'],
    'da' => ['name' => 'Danish', 'flag' => 'dk'],
    'de' => ['name' => 'German', 'flag' => 'de'],
    'dz' => ['name' => 'Bhutani', 'flag' => 'bt'],
    'el' => ['name' => 'Greek', 'flag' => 'gr'],
    'en' => ['name' => 'English', 'flag' => 'us'],
    'eo' => ['name' => 'Esperanto', 'flag' => 'xx'],
    'es' => ['name' => 'Spanish', 'flag' => 'es'],
    'et' => ['name' => 'Estonian', 'flag' => 'ee'],
    'eu' => ['name' => 'Basque', 'flag' => 'es'],
    'fa' => ['name' => 'Persian', 'flag' => 'ir'],
    'fi' => ['name' => 'Finnish', 'flag' => 'fi'],
    'fj' => ['name' => 'Fiji', 'flag' => 'fj'],
    'fo' => ['name' => 'Faeroese', 'flag' => 'fo'],
    'fr' => ['name' => 'French', 'flag' => 'fr'],
    'fy' => ['name' => 'Frisian', 'flag' => 'nl'],
    'ga' => ['name' => 'Irish', 'flag' => 'ie'],
    'gd' => ['name' => 'Scots/Gaelic', 'flag' => 'gb'],
    'gl' => ['name' => 'Galician', 'flag' => 'es'],
    'gn' => ['name' => 'Guarani', 'flag' => 'py'],
    'gu' => ['name' => 'Gujarati', 'flag' => 'in'],
    'ha' => ['name' => 'Hausa', 'flag' => 'ng'],
    'hi' => ['name' => 'Hindi', 'flag' => 'in'],
    'hr' => ['name' => 'Croatian', 'flag' => 'hr'],
    'hu' => ['name' => 'Hungarian', 'flag' => 'hu'],
    'hy' => ['name' => 'Armenian', 'flag' => 'am'],
    'ia' => ['name' => 'Interlingua', 'flag' => 'xx'],
    'id' => ['name' => 'Indonesian', 'flag' => 'id'],
    'ie' => ['name' => 'Interlingue', 'flag' => 'xx'],
    'ik' => ['name' => 'Inupiak', 'flag' => 'us'],
    'in' => ['name' => 'Indonesian', 'flag' => 'id'],
    'is' => ['name' => 'Icelandic', 'flag' => 'is'],
    'it' => ['name' => 'Italian', 'flag' => 'it'],
    'iw' => ['name' => 'Hebrew', 'flag' => 'il'],
    'ja' => ['name' => 'Japanese', 'flag' => 'jp'],
    'ji' => ['name' => 'Yiddish', 'flag' => 'xx'],
    'jw' => ['name' => 'Javanese', 'flag' => 'id'],
    'ka' => ['name' => 'Georgian', 'flag' => 'ge'],
    'kk' => ['name' => 'Kazakh', 'flag' => 'kz'],
    'kl' => ['name' => 'Greenlandic', 'flag' => 'gl'],
    'km' => ['name' => 'Cambodian', 'flag' => 'kh'],
    'kn' => ['name' => 'Kannada', 'flag' => 'in'],
    'ko' => ['name' => 'Korean', 'flag' => 'kr'],
    'ks' => ['name' => 'Kashmiri', 'flag' => 'in'],
    'ku' => ['name' => 'Kurdish', 'flag' => 'iq'],
    'ky' => ['name' => 'Kirghiz', 'flag' => 'kg'],
    'la' => ['name' => 'Latin', 'flag' => 'xx'],
    'ln' => ['name' => 'Lingala', 'flag' => 'cg'],
    'lo' => ['name' => 'Laothian', 'flag' => 'la'],
    'lt' => ['name' => 'Lithuanian', 'flag' => 'lt'],
    'lv' => ['name' => 'Latvian/Lettish', 'flag' => 'lv'],
    'mg' => ['name' => 'Malagasy', 'flag' => 'mg'],
    'mi' => ['name' => 'Maori', 'flag' => 'nz'],
    'mk' => ['name' => 'Macedonian', 'flag' => 'mk'],
    'ml' => ['name' => 'Malayalam', 'flag' => 'in'],
    'mn' => ['name' => 'Mongolian', 'flag' => 'mn'],
    'mo' => ['name' => 'Moldavian', 'flag' => 'md'],
    'mr' => ['name' => 'Marathi', 'flag' => 'in'],
    'ms' => ['name' => 'Malay', 'flag' => 'my'],
    'mt' => ['name' => 'Maltese', 'flag' => 'mt'],
    'my' => ['name' => 'Burmese', 'flag' => 'mm'],
    'na' => ['name' => 'Nauru', 'flag' => 'nr'],
    'ne' => ['name' => 'Nepali', 'flag' => 'np'],
    'nl' => ['name' => 'Dutch', 'flag' => 'nl'],
    'no' => ['name' => 'Norwegian', 'flag' => 'no'],
    'oc' => ['name' => 'Occitan', 'flag' => 'fr'],
    'pa' => ['name' => 'Punjabi', 'flag' => 'in'],
    'pl' => ['name' => 'Polish', 'flag' => 'pl'],
    'ps' => ['name' => 'Pashto/Pushto', 'flag' => 'af'],
    'pt' => ['name' => 'Portuguese', 'flag' => 'pt'],
    'qu' => ['name' => 'Quechua', 'flag' => 'pe'],
    'rm' => ['name' => 'Rhaeto-Romance', 'flag' => 'ch'],
    'rn' => ['name' => 'Kirundi', 'flag' => 'bi'],
    'ro' => ['name' => 'Romanian', 'flag' => 'ro'],
    'ru' => ['name' => 'Russian', 'flag' => 'ru'],
    'rw' => ['name' => 'Kinyarwanda', 'flag' => 'rw'],
    'sa' => ['name' => 'Sanskrit', 'flag' => 'in'],
    'sd' => ['name' => 'Sindhi', 'flag' => 'pk'],
    'sg' => ['name' => 'Sangro', 'flag' => 'cf'],
    'si' => ['name' => 'Singhalese', 'flag' => 'lk'],
    'sk' => ['name' => 'Slovak', 'flag' => 'sk'],
    'sl' => ['name' => 'Slovenian', 'flag' => 'si'],
    'sm' => ['name' => 'Samoan', 'flag' => 'ws'],
    'sn' => ['name' => 'Shona', 'flag' => 'zw'],
    'so' => ['name' => 'Somali', 'flag' => 'so'],
    'sq' => ['name' => 'Albanian', 'flag' => 'al'],
    'sr' => ['name' => 'Serbian', 'flag' => 'rs'],
    'ss' => ['name' => 'Siswati', 'flag' => 'sz'],
    'st' => ['name' => 'Sesotho', 'flag' => 'ls'],
    'su' => ['name' => 'Sundanese', 'flag' => 'id'],
    'sv' => ['name' => 'Swedish', 'flag' => 'se'],
    'sw' => ['name' => 'Swahili', 'flag' => 'ke'],
    'ta' => ['name' => 'Tamil', 'flag' => 'lk'],
    'te' => ['name' => 'Tegulu', 'flag' => 'in'],
    'tg' => ['name' => 'Tajik', 'flag' => 'tj'],
    'th' => ['name' => 'Thai', 'flag' => 'th'],
    'ti' => ['name' => 'Tigrinya', 'flag' => 'er'],
    'tk' => ['name' => 'Turkmen', 'flag' => 'tm'],
    'tl' => ['name' => 'Tagalog', 'flag' => 'ph'],
    'tn' => ['name' => 'Setswana', 'flag' => 'bw'],
    'to' => ['name' => 'Tonga', 'flag' => 'to'],
    'tr' => ['name' => 'Turkish', 'flag' => 'tr'],
    'ts' => ['name' => 'Tsonga', 'flag' => 'za'],
    'tt' => ['name' => 'Tatar', 'flag' => 'ru'],
    'tw' => ['name' => 'Twi', 'flag' => 'gh'],
    'uk' => ['name' => 'Ukrainian', 'flag' => 'ua'],
    'ur' => ['name' => 'Urdu', 'flag' => 'pk'],
    'uz' => ['name' => 'Uzbek', 'flag' => 'uz'],
    'vi' => ['name' => 'Vietnamese', 'flag' => 'vn'],
    'vo' => ['name' => 'Volapuk', 'flag' => 'xx'],
    'wo' => ['name' => 'Wolof', 'flag' => 'sn'],
    'xh' => ['name' => 'Xhosa', 'flag' => 'za'],
    'yo' => ['name' => 'Yoruba', 'flag' => 'ng'],
    'zh' => ['name' => 'Chinese', 'flag' => 'cn'],
    'zu' => ['name' => 'Zulu', 'flag' => 'za'],
];

// Sort by name here
asort($language);

return $language;