<?php

return [
    'direct'           => [
        'label'  => 'Live Stream (Direct)',
        'fields' => [
            [
                'label'       => 'Stream URL',
                'name'        => 'direct-url',
                'map'         => 'url',
                'placeholder' => 'http://192.168.1.1:8000/mount',
                'required'    => true,
                'class'       => 'col-sm-5',
            ],
            [
                'label'       => 'Stream URL (Fallback)',
                'name'        => 'direct-url-fallback',
                'map'         => 'fallback',
                'placeholder' => 'http://192.168.1.1:8000/fallback-mount',
                'class'       => 'col-sm-5',
                'description' => '(not required)',
            ],
        ],
    ],
    'azuracast'        => [
        'label'  => 'Azuracast (API)',
        'fields' => [
            [
                'label'       => 'Azuracast API URL',
                'name'        => 'azura-url',
                'map'         => 'url',
                'placeholder' => 'http://your-azuracast-site.example.com/api/nowplaying/station_shortcode',
                'class'       => 'col-sm-6',
                'required'    => true,
                'description' => '(Please check out <a href="https://doc.prahec.com/pawtunes#live-information-azura-cast" target="_blank">the documentation <i class="fas fa-info-circle"></i></a>)',
            ],
            [
                'label'       => 'Station Shortcode',
                'name'        => 'azura-station',
                'map'         => 'station',
                'placeholder' => 'your_station_name',
                'class'       => 'col-sm-6',
                'required'    => true,
                'description' => 'URL stub or short name.',
            ],
            [
                'label'       => 'Track Artwork',
                'class'       => 'col-sm-9',
                'name'        => 'azura-use-cover',
                'map'         => 'use-cover',
                'value'       => "true",
                'type'        => 'checkbox',
                'description' => 'Use Artworks from Azuracast API (Prioritized when images are missing on the player)',
            ],
            [
                'label'       => 'History',
                'class'       => 'col-sm-9',
                'name'        => 'azura-history',
                'map'         => 'azura-history',
                'value'       => "true",
                'type'        => 'checkbox',
                'description' => 'If song history is available on the API, use the provided history instead.',
            ],
        ],
    ],
    'shoutcast'        => [
        'label'  => 'Shoutcast (Admin)',
        'fields' => [
            [
                'label'        => 'Shoutcast Status Page',
                'name'         => 'shoutcast-url',
                'map'          => 'url',
                'required'     => true,
                'placeholder'  => 'http://192.168.1.1:8000/',
                'class'        => 'col-sm-5',
                'autocomplete' => 'new-password',
            ],
            [
                'label'        => 'Admin Password',
                'name'         => 'shoutcast-pass',
                'map'          => 'auth',
                'placeholder'  => 'password',
                'class'        => 'col-sm-5',
                'required'     => true,
                'autocomplete' => 'new-password4',
                'type'         => 'password',
            ],
            [
                'label'       => 'SID',
                'name'        => 'shoutcast-sid',
                'map'         => 'sid',
                'placeholder' => '1',
                'class'       => 'col-sm-2',
                'description' => '(Leave empty if running version 1.x)',
            ],
            [
                'label'       => 'History',
                'class'       => 'col-sm-9',
                'name'        => 'sc-history',
                'map'         => 'sc-history',
                'value'       => "true",
                'type'        => 'checkbox',
                'description' => 'If song history is available on Shoutcast server, use provided history instead.',
            ],
        ],
    ],
    'shoutcast-public' => [
        'label'  => 'Shoutcast (Public)',
        'fields' => [
            [
                'label'       => 'Shoutcast URL',
                'name'        => 'shoutcast-public-url',
                'map'         => 'url',
                'placeholder' => 'http://192.168.1.1:8000/',
                'class'       => 'col-sm-5',
                'required'    => true,
            ],
            [
                'label'       => 'SID',
                'name'        => 'shoutcast-public-sid',
                'map'         => 'sid',
                'placeholder' => '1',
                'class'       => 'col-sm-2',
                'description' => '(Leave empty if running version 1.x)',
            ],
        ],
    ],
    'icecast'          => [
        'label'  => 'Icecast (Admin)',
        'fields' => [
            [
                'label'       => 'Icecast Status Page',
                'name'        => 'icecast-url',
                'map'         => 'url',
                'placeholder' => 'http://shoutcast:8000/',
                'class'       => 'col-sm-5',
                'required'    => true,
            ],
            [
                'autocomplete' => 'new-password',
                'label'        => 'Admin Username',
                'name'         => 'icecast-user',
                'map'          => 'auth-user',
                'placeholder'  => 'admin',
                'class'        => 'col-sm-5',
                'required'     => true,
            ],
            [
                'autocomplete' => 'new-password',
                'label'        => 'Admin Password',
                'name'         => 'icecast-pass',
                'map'          => 'auth-pass',
                'placeholder'  => 'password',
                'class'        => 'col-sm-5',
                'type'         => 'password',
                'required'     => true,
            ],
            [
                'label'       => 'Mount Point',
                'name'        => 'icecast-mount',
                'map'         => 'mount',
                'placeholder' => '/autodj',
                'class'       => 'col-sm-3',
                'required'    => true,
            ],
            [
                'label'       => 'Fallback Mount',
                'name'        => 'icecast-fallback-mount',
                'map'         => 'fallback',
                'placeholder' => '/stream',
                'class'       => 'col-sm-3',
                'description' => '(Fallback to this mount if main has no info, not required)',
            ],
        ],
    ],
    'icecast-public'   => [
        'label'  => 'Icecast (Public)',
        'fields' => [
            [
                'label'       => 'Icecast URL',
                'name'        => 'icecast-public-url',
                'map'         => 'url',
                'placeholder' => 'http://icecast.com:8000/',
                'class'       => 'col-sm-5',
                'required'    => true,
            ],
            [
                'label'       => 'Mount',
                'name'        => 'icecast-public-mount',
                'map'         => 'mount',
                'placeholder' => '/stream',
                'class'       => 'col-sm-3',
            ],
        ],
    ],
    'sam'              => [
        'label'  => 'SAM Broadcaster (MySQL)',
        'fields' => [
            [
                'autocomplete' => 'new-password',
                'label'        => 'MySQL Host',
                'name'         => 'sam-host',
                'map'          => 'host',
                'placeholder'  => '127.0.0.1',
                'class'        => 'col-sm-5',
                'required'     => true,
            ],
            [
                'autocomplete' => 'new-password',
                'label'        => 'MySQL Username',
                'name'         => 'sam-user',
                'map'          => 'auth-user',
                'placeholder'  => 'root',
                'class'        => 'col-sm-5',
                'required'     => true,
            ],
            [
                'autocomplete' => 'new-password',
                'label'        => 'MySQL Password',
                'name'         => 'sam-pass',
                'map'          => 'auth-pass',
                'placeholder'  => 'password',
                'class'        => 'col-sm-5',
                'type'         => 'password',
            ],
            [
                'label'       => 'SAM Database',
                'name'        => 'sam-db',
                'map'         => 'db',
                'placeholder' => 'sam',
                'class'       => 'col-sm-3',
                'required'    => true,
            ],
        ],
    ],
    'centovacast'      => [
        'label'  => 'Centovacast API (Public)',
        'fields' => [
            [
                'label'       => 'Centovacast URL',
                'name'        => 'centova-url',
                'map'         => 'url',
                'placeholder' => 'http://192.168.1.1:2199/',
                'class'       => 'col-sm-5',
                'required'    => true,
            ],
            [
                'label'       => 'Centovacast Username',
                'name'        => 'centova-user',
                'map'         => 'user',
                'placeholder' => 'JohnDoe',
                'class'       => 'col-sm-4',
                'description' => '(Recent Tracks widget must be enabled!)',
                'required'    => true,
            ],
            [
                'label'       => 'Track Artwork',
                'class'       => 'col-sm-9',
                'name'        => 'centova-use-cover',
                'map'         => 'use-cover',
                'value'       => "true",
                'type'        => 'checkbox',
                'description' => 'Use Artworks from Centova Cast API (Prioritized when images are missing on the player)',
            ],
        ],
    ],
    'custom'           => [
        'label'  => 'Custom (External API)',
        'fields' => [
            [
                'label'       => 'Custom URL',
                'name'        => 'custom-url',
                'map'         => 'url',
                'placeholder' => 'http://domain.com/file.php',
                'class'       => 'col-sm-5',
                'required'    => true,
                'description' => '(Please read the <a href="https://doc.prahec.com/pawtunes#live-information-custom" target="_blank">Documentation</a>)',
            ],
            [
                'label'        => 'HTTP-Auth Username',
                'name'         => 'custom-user',
                'map'          => 'user',
                'placeholder'  => 'JohnDoe',
                'class'        => 'col-sm-4',
                'description'  => '(Optional)',
                'autocomplete' => 'new-password',
            ],
            [
                'label'        => 'HTTP-Auth Password',
                'name'         => 'custom-pass',
                'map'          => 'pass',
                'placeholder'  => 'Password',
                'class'        => 'col-sm-4',
                'description'  => '(Optional)',
                'type'         => 'password',
                'autocomplete' => 'new-password',
            ],
        ],
    ],
    'disabled'         => [
        'label'  => 'Disabled',
        'fields' => [],
    ],
];