<?php
$nombre   = htmlspecialchars($_POST['nombre']);
$ip       = htmlspecialchars($_POST['ip']);
$port     = htmlspecialchars($_POST['port']);
$logo     = htmlspecialchars($_POST['logo']);
$oyentes  = htmlspecialchars($_POST['oyentes']); // true o false
$version  = htmlspecialchars($_POST['version']); // 1 o 2
$autoplay = htmlspecialchars($_POST['autoplay']); // true o false

// Limpieza de IP por seguridad
$ip = str_replace(['http://', 'https://', '/'], '', $ip);
$stream_url = "https://" . $ip . ":" . $port . "/;"; // El /; ayuda a compatibilidad en algunos navegadores

// URL donde está alojado tu script info.php (detecta automáticamente tu dominio actual)
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
$base_url = $protocol . "://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
$info_api = $base_url . "/info.php"; 
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reproductor Generado</title>
    <style>
        body { font-family: Arial, sans-serif; text-align: center; padding: 20px; background: #f4f4f4; }
        .container { background: #fff; max-width: 700px; margin: 0 auto; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        textarea { width: 100%; height: 250px; font-family: monospace; font-size: 12px; border: 1px solid #ccc; padding: 10px; background: #eee; }
        .btn { display: inline-block; padding: 10px 20px; background: #28a745; color: white; text-decoration: none; border-radius: 5px; margin-top: 10px; border: none; cursor: pointer; }
        .preview-box { margin-top: 30px; border-top: 2px solid #ddd; padding-top: 20px; }
    </style>
</head>
<body>

<div class="container">
    <h2>¡Reproductor Listo!</h2>
    <p>Copia el siguiente código. Este reproductor usa tecnología HTML5 nativa y <b>no tendrá errores de CORS</b>.</p>

    <textarea id="codeArea" readonly>
<style>
    .mi-player { background: #222; color: #fff; width: 300px; padding: 15px; border-radius: 10px; font-family: sans-serif; text-align: center; margin: 0 auto; }
    .mi-player img { width: 100px; height: 100px; border-radius: 50%; object-fit: cover; margin-bottom: 10px; border: 3px solid #fff; }
    .mi-player h3 { margin: 5px 0; font-size: 16px; color: #f1f1f1; }
    .mi-player .song-title { color: #00e676; font-size: 14px; margin-bottom: 10px; font-weight: bold; min-height: 20px;}
    .mi-player audio { width: 100%; outline: none; margin-top: 10px; }
    .mi-player .listeners { font-size: 11px; color: #ccc; margin-top: 5px; }
</style>

<div class="mi-player">
    <img src="<?php echo $logo; ?>" alt="Logo">
    <h3><?php echo $nombre; ?></h3>
    <div class="song-title" id="current-song">Cargando...</div>
    
    <audio id="audioPlayer" controls <?php echo ($autoplay == 'true') ? 'autoplay' : ''; ?> preload="none">
        <source src="<?php echo $stream_url; ?>" type="audio/mpeg">
        Tu navegador no soporta el audio.
    </audio>
    
    <?php if($oyentes == 'true'): ?>
    <div class="listeners">Oyentes: <span id="listener-count">0</span></div>
    <?php endif; ?>
</div>

<script>
(function(){
    var updateInterval = 15000; // Actualizar cada 15 segundos
    var apiUrl = "<?php echo $info_api; ?>?ip=<?php echo $ip; ?>&port=<?php echo $port; ?>&version=<?php echo $version; ?>";

    function updateMetadata() {
        fetch(apiUrl)
            .then(response => response.json())
            .then(data => {
                var titleElement = document.getElementById('current-song');
                if(data.title) {
                    titleElement.innerText = data.title;
                }
                <?php if($oyentes == 'true'): ?>
                var listenersElement = document.getElementById('listener-count');
                if(data.listeners) {
                    listenersElement.innerText = data.listeners;
                }
                <?php endif; ?>
            })
            .catch(error => console.log('Error metadata:', error));
    }

    // Iniciar actualización
    updateMetadata();
    setInterval(updateMetadata, updateInterval);
    
    // Fix para Autoplay en Chrome (requiere interacción a veces)
    var audio = document.getElementById("audioPlayer");
    audio.volume = 1.0;
})();
</script>
</textarea>
    
    <button onclick="copiarCodigo()" class="btn">Copiar Código</button>
    <a href="index.php" class="btn" style="background-color: #666;">Volver</a>

    <div class="preview-box">
        <h3>Vista Previa:</h3>
        <?php 
            // Inyectamos el mismo HTML que generamos arriba para la vista previa
            // Nota: Usamos un pequeño truco de buffer para no repetir código PHP, pero por claridad lo repetiré simplificado
        ?>
        <div style="max-width:320px; margin:0 auto;">
            <style>
                .mi-player-prev { background: #222; color: #fff; padding: 15px; border-radius: 10px; font-family: sans-serif; text-align: center; }
                .mi-player-prev img { width: 80px; height: 80px; border-radius: 50%; object-fit: cover; margin-bottom: 10px; border: 2px solid #fff; }
                .song-title-prev { color: #00e676; font-size: 14px; margin: 10px 0; font-weight: bold; }
            </style>
            <div class="mi-player-prev">
                <img src="<?php echo $logo; ?>">
                <h3><?php echo $nombre; ?></h3>
                <div class="song-title-prev" id="prev-song">Conectando...</div>
                <audio controls src="<?php echo $stream_url; ?>" style="width:100%"></audio>
            </div>
            <script>
                // Script simple para la vista previa
                setInterval(function(){
                    fetch("<?php echo $info_api; ?>?ip=<?php echo $ip; ?>&port=<?php echo $port; ?>&version=<?php echo $version; ?>")
                    .then(r => r.json()).then(d => {
                        document.getElementById('prev-song').innerText = d.title || 'En vivo';
                    });
                }, 5000);
            </script>
        </div>
    </div>
</div>

<script>
    function copiarCodigo() {
        var copyText = document.getElementById("codeArea");
        copyText.select();
        document.execCommand("copy");
        alert("Código copiado al portapapeles");
    }
</script>

</body>
</html>