<?php
// info.php - Proxy para evitar CORS y obtener metadatos
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *'); // Permitir acceso desde cualquier lugar (opcional)

$ip = isset($_GET['ip']) ? $_GET['ip'] : '';
$port = isset($_GET['port']) ? $_GET['port'] : '';
$version = isset($_GET['version']) ? $_GET['version'] : '1';

if(empty($ip) || empty($port)) {
    echo json_encode(["error" => "Faltan datos"]);
    exit;
}

// Limpiamos la IP de http/https por si acaso
$ip = str_replace(['http://', 'https://'], '', $ip);

// Construimos la URL de estadísticas según la versión de Shoutcast
if ($version == '2') {
    // Shoutcast v2
    $url = "http://{$ip}:{$port}/stats?sid=1&json=1";
} else {
    // Shoutcast v1 (el clásico 7.html)
    $url = "http://{$ip}:{$port}/7.html";
}

// Iniciamos CURL para hacer la petición
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');
curl_setopt($ch, CURLOPT_TIMEOUT, 5);
$data = curl_exec($ch);
curl_close($ch);

if ($data === false || empty($data)) {
    echo json_encode(["title" => "Radio Offline", "listeners" => "0"]);
    exit;
}

// Procesamos la respuesta
if ($version == '2') {
    // Si es V2, suele ser XML o JSON. Intentamos JSON primero.
    $json = json_decode($data, true);
    if(isset($json['songtitle'])) {
        echo json_encode([
            "title" => $json['songtitle'],
            "listeners" => $json['currentlisteners']
        ]);
    } else {
        // Fallback básico para XML si fuera necesario
         echo json_encode(["title" => "En vivo", "listeners" => "-"]);
    }
} else {
    // Si es V1, parseamos el HTML del 7.html (formato: listeners,status,peak,max,unique,bitrate,song)
    // Ejemplo de 7.html body: 20,1,55,500,20,128,Cancion - Artista
    $content = strip_tags($data); 
    $parts = explode(',', $content);
    
    if (count($parts) >= 6) {
        // A veces el título tiene comas, así que unimos el resto
        $song = implode(',', array_slice($parts, 6)); 
        echo json_encode([
            "title" => trim($song),
            "listeners" => $parts[0]
        ]);
    } else {
        echo json_encode(["title" => "Desconocido", "listeners" => "0"]);
    }
}
?>